<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="maincontentcontainer">
 *
 * @package Quark
 * @since Quark 1.0
 */
?><!doctype html>
<!-- paulirish.com/2008/conditional-stylesheets-vs-css-hacks-answer-neither/ -->
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 7]>    <html class="no-js lt-ie9 lt-ie8" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8]>    <html class="no-js lt-ie9" <?php language_attributes(); ?>> <![endif]-->
<!-- Consider adding a manifest.appcache: h5bp.com/d/Offline -->
<!--[if gt IE 8]><!--> <html class="no-js" <?php language_attributes(); ?>> <!--<![endif]-->


<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame -->
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<meta http-equiv="cleartype" content="on">

	<!-- Responsive and mobile friendly stuff -->
	<meta name="HandheldFriendly" content="True">
	<meta name="MobileOptimized" content="320">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<link rel="icon" href="<?php bloginfo('template_url')?>/images/favicon.png" type="image/png" />
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

	<?php wp_head(); ?>
<style>

.col {
	display: block;
	float:left;
	margin: 0 0 0 1.6%;
}

/* Remove the margin on the first column. Works on all browsers incl. IE7+ */
.col:first-child { margin-left: 0; }

.row {
	clear: both;
	margin: 0 auto;
	*zoom: 1;
}

.row:before,
.row:after {
	content: "";
	display: table;
}

.row:after { clear: both; }


/* ==========================================================================
   Twelve Column Grid
   ========================================================================== */

.grid_12_of_12 { width: 100%; }
.grid_11_of_12 { width: 91.53%; }
.grid_10_of_12 { width: 83.06%; }
.grid_9_of_12  { width: 74.6%; }
.grid_8_of_12  { width: 66.13%; }
.grid_7_of_12  { width: 57.66%; }
.grid_6_of_12  { width: 49.2%; }
.grid_5_of_12  { width: 40.73%; }
.grid_4_of_12  { width: 32.26%; }
.grid_3_of_12  { width: 23.8%; }
.grid_2_of_12  { width: 15.33%; }
.grid_1_of_12  { width: 6.866%; }
</style>


</head>

<body <?php body_class(); ?>>

<div id="wrapper" class="hfeed site">

	<div class="visuallyhidden skip-link"><a href="#primary" title="<?php esc_attr_e( 'Skip to main content', 'quark' ); ?>"><?php esc_html_e( 'Skip to main content', 'quark' ); ?></a></div>

	<div id="headercontainer">

		<header id="masthead" role="banner">
			<div class="site-header-wrapper">
				<div class="site-header">
					<div class="row-bs">
						<div class="col-md-12 site-title site-slogan">
							<?php dynamic_sidebar( 'sidebar-header2' ); ?>
						</div>
					</div>
				</div>
			</div>
		</header> <!-- /#masthead.site-header.row-fluid -->

	</div> <!-- /#headercontainer -->
	<div id="maincontentcontainer" data-stellar-background-ratio="-0.05">
		<div id="bannercontainer">
			<div class="site-header intro">
				<div class="row-bs">
					<div class="col-md-12">
						<?php dynamic_sidebar( 'frontpage-banner1' ); ?>
						<div class="school-logo"><img src="<?php bloginfo('template_url'); ?>/images/logo.png" width="auto" height="auto" alt="" /></div>
					</div>
				</div>
			</div>
		</div>
		<?php	do_action( 'quark_before_woocommerce' ); ?>