<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */

function optionsframework_option_name() {
	$themename = get_option( 'stylesheet' );
	$themename = preg_replace( "/\W/", "_", strtolower( $themename ) );
	return $themename;
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'quark'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

	// If using image radio buttons, define a directory path
	$imagepath =  trailingslashit( get_template_directory_uri() ) . 'images/';

	// Background Defaults
	$background_defaults = array(
		'color' => '#222222',
		'image' => $imagepath . 'dark-noise.jpg',
		'repeat' => 'repeat',
		'position' => 'top left',
		'attachment'=>'scroll' );

	// Editor settings
	$wp_editor_settings = array(
		'wpautop' => true, // Default
		'textarea_rows' => 5,
		'tinymce' => array( 'plugins' => 'wordpress' )
	);

	// Footer Position settings
	$footer_position_settings = array(
		'left' => esc_html__( 'Left aligned', 'quark' ),
		'center' => esc_html__( 'Center aligned', 'quark' ),
		'right' => esc_html__( 'Right aligned', 'quark' )
	);

	// Number of shop products
	$shop_products_settings = array(
		'4' => esc_html__( '4 Products', 'quark' ),
		'8' => esc_html__( '8 Products', 'quark' ),
		'12' => esc_html__( '12 Products', 'quark' ),
		'16' => esc_html__( '16 Products', 'quark' ),
		'20' => esc_html__( '20 Products', 'quark' ),
		'24' => esc_html__( '24 Products', 'quark' ),
		'28' => esc_html__( '28 Products', 'quark' )
	);

	$options = array();

	$options[] = array(
		'name' => esc_html__( 'Basic Settings', 'quark' ),
		'type' => 'heading' );

	$options[] = array(
		'name' => esc_html__( 'Background', 'quark' ),
		'desc' => sprintf( wp_kses( __( 'If you&rsquo;d like to replace or remove the default background image, use the <a href="%1$s" title="Custom background">Appearance &gt; Background</a> menu option.', 'quark' ), array(
			'a' => array(
				'href' => array(),
				'title' => array() )
			) ), admin_url( 'themes.php?page=custom-background' ) ),
		'type' => 'info' );

	$options[] = array(
		'name' => esc_html__( 'Logo', 'quark' ),
		'desc' => sprintf( wp_kses( __( 'If you&rsquo;d like to replace or remove the default logo, use the <a href="%1$s" title="Custom header">Appearance &gt; Header</a> menu option.', 'quark' ), array(
			'a' => array(
				'href' => array(),
				'title' => array() )
			) ), admin_url( 'themes.php?page=custom-header' ) ),
		'type' => 'info' );

	$options[] = array(
		'name' => esc_html__( 'Social Media Settings', 'quark' ),
		'desc' => esc_html__( 'Enter the URLs for your Social Media platforms. You can also optionally specify whether you want these links opened in a new browser tab/window.', 'quark' ),
		'type' => 'info' );

	$options[] = array(
		'name' => esc_html__('Open links in new Window/Tab', 'quark'),
		'desc' => esc_html__('Open the social media links in a new browser tab/window', 'quark'),
		'id' => 'social_newtab',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'Twitter', 'quark' ),
		'desc' => esc_html__( 'Enter your Twitter URL.', 'quark' ),
		'id' => 'social_twitter',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Facebook', 'quark' ),
		'desc' => esc_html__( 'Enter your Facebook URL.', 'quark' ),
		'id' => 'social_facebook',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Google+', 'quark' ),
		'desc' => esc_html__( 'Enter your Google+ URL.', 'quark' ),
		'id' => 'social_googleplus',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'LinkedIn', 'quark' ),
		'desc' => esc_html__( 'Enter your LinkedIn URL.', 'quark' ),
		'id' => 'social_linkedin',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'HomeStars', 'quark' ),
		'desc' => esc_html__( 'Enter your Homestars URL.', 'quark' ),
		'id' => 'social_homestars',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Slack', 'quark' ),
		'desc' => esc_html__( 'Enter your Slack URL.', 'quark' ),
		'id' => 'social_slack',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Houzz', 'quark' ),
		'desc' => esc_html__( 'Enter your Houzz URL.', 'quark' ),
		'id' => 'social_houzz',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Tumblr', 'quark' ),
		'desc' => esc_html__( 'Enter your Tumblr URL.', 'quark' ),
		'id' => 'social_tumblr',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Reddit', 'quark' ),
		'desc' => esc_html__( 'Enter your Reddit URL.', 'quark' ),
		'id' => 'social_reddit',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Twitch', 'quark' ),
		'desc' => esc_html__( 'Enter your Twitch URL.', 'quark' ),
		'id' => 'social_twitch',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'GitHub', 'quark' ),
		'desc' => esc_html__( 'Enter your GitHub URL.', 'quark' ),
		'id' => 'social_github',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Bitbucket', 'quark' ),
		'desc' => esc_html__( 'Enter your Bitbucket URL.', 'quark' ),
		'id' => 'social_bitbucket',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Stack Overflow', 'quark' ),
		'desc' => esc_html__( 'Enter your Stack Overflow URL.', 'quark' ),
		'id' => 'social_stackoverflow',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'CodePen', 'quark' ),
		'desc' => esc_html__( 'Enter your CodePen URL.', 'quark' ),
		'id' => 'social_codepen',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Foursquare', 'quark' ),
		'desc' => esc_html__( 'Enter your Foursquare URL.', 'quark' ),
		'id' => 'social_foursquare',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'YouTube', 'quark' ),
		'desc' => esc_html__( 'Enter your YouTube URL.', 'quark' ),
		'id' => 'social_youtube',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Vimeo', 'quark' ),
		'desc' => esc_html__( 'Enter your Vimeo URL.', 'quark' ),
		'id' => 'social_vimeo',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Instagram', 'quark' ),
		'desc' => esc_html__( 'Enter your Instagram URL.', 'quark' ),
		'id' => 'social_instagram',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Vine', 'quark' ),
		'desc' => esc_html__( 'Enter your Vine URL.', 'quark' ),
		'id' => 'social_vine',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Snapchat', 'quark' ),
		'desc' => esc_html__( 'Enter your Snapchat URL.', 'quark' ),
		'id' => 'social_snapchat',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Flickr', 'quark' ),
		'desc' => esc_html__( 'Enter your Flickr URL.', 'quark' ),
		'id' => 'social_flickr',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Pinterest', 'quark' ),
		'desc' => esc_html__( 'Enter your Pinterest URL.', 'quark' ),
		'id' => 'social_pinterest',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'RSS', 'quark' ),
		'desc' => esc_html__( 'Enter your RSS Feed URL.', 'quark' ),
		'id' => 'social_rss',
		'std' => '',
		'type' => 'text' );

	$options[] = array(
		'name' => esc_html__( 'Advanced settings', 'quark' ),
		'type' => 'heading' );

	$options[] = array(
		'name' =>  esc_html__( 'Banner Background', 'quark' ),
		'desc' => esc_html__( 'Select an image and background color for the homepage banner.', 'quark' ),
		'id' => 'banner_background',
		'std' => $background_defaults,
		'type' => 'background' );

	$options[] = array(
		'name' => esc_html__( 'Footer Background Color', 'quark' ),
		'desc' => esc_html__( 'Select the background color for the footer.', 'quark' ),
		'id' => 'footer_color',
		'std' => '#222222',
		'type' => 'color' );

	$options[] = array(
		'name' => esc_html__( 'Footer Content', 'quark' ),
		'desc' => esc_html__( 'Enter the text you&lsquo;d like to display in the footer. This content will be displayed just below the footer widgets. It&lsquo;s ideal for displaying your copyright message or credits.', 'quark' ),
		'id' => 'footer_content',
		'std' => quark_get_credits(),
		'type' => 'editor',
		'settings' => $wp_editor_settings );

	$options[] = array(
		'name' => esc_html__( 'Footer Content Position', 'quark' ),
		'desc' => esc_html__( 'Select what position you would like the footer content aligned to.', 'quark' ),
		'id' => 'footer_position',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini',
		'options' => $footer_position_settings );



	return $options;
}
