<?php
/**
 * Template Name: Front Page Template
 *
 * Description: Displays a full-width front page. The front page template provides an optional
 * banner section that allows for highlighting a key message. It can contain up to 2 widget areas,
 * in one or two columns. These widget areas are dynamic so if only one widget is used, it will be
 * displayed in one column. If two are used, then they will be displayed over 2 columns.
 * There are also four front page only widgets displayed just beneath the main content. Like the
 * banner widgets, they will be displayed in anywhere from one to four columns, depending on
 * how many widgets are active.
 *
 * @package Quark
 * @since Quark 1.0
 */

get_header(); ?>

	<?php get_sidebar( 'front' ); ?>
	<div id="primary" role="main">
		<div class="separ"></div>
		<div class="site-content row">
			<?php if ( have_posts() ) : ?>
				<div class="row-bs">
					
					<?php while ( have_posts() ) : the_post(); ?>
						<div class="col-md-4">
							<?php the_content(); ?>
						</div>
						<div class="col-md-3 col-sm-6">
							<?php the_excerpt(); ?>
						</div>
						
						<?php if ( has_post_thumbnail() ) { ?>
						<div class="col-md-5 col-sm-6">
							<?php the_post_thumbnail( 'full' ); ?>
						</div>
						<?php } ?>
						
					<?php endwhile; // end of the loop. ?>
					
				</div>
			<?php endif; // end have_posts() check ?>
		</div>
	</div><!-- /#primary.site-content.row -->
	
	<div id="promo-pull">
		<div class="separ"></div>
		<div class="site-content">
			<div class="row-bs">
				<?php dynamic_sidebar( 'frontpage-banner2' ); ?>
			</div>
		</div>
	</div>
	<div class="portfolio-wrapper" data-stellar-background-ratio="-0.3">
		<div class="row">
			<div class="col grid_12_of_12">
				<?php dynamic_sidebar( 'sidebar-homepage1'); ?>
			</div>
		</div>
	</div>

<?php get_footer(); ?>
