<?php
/**
 * The Template for displaying all single posts.
 *
 * @package Quark
 * @since Quark 1.0
 */

get_header(); ?>

	<div id="primary" class="site-content row" role="main">

			<div class="col grid_12_of_12">
				<div class="row-bs">
					<div class="col-md-12">
						<?php if ( function_exists('yoast_breadcrumb') ) {yoast_breadcrumb('<p id="breadcrumbs">','</p>');} ?>
					</div>
				</div>
				<?php while ( have_posts() ) : the_post(); ?>
				
				<div class="row">
					<div class="col grid_6_of_12 carousel">
						<ul id="proj-imgs" class="proj-imgs">
						<?php
						$galleryArray = get_post_gallery_ids($post->ID); 
						foreach ($galleryArray as $id) : ?>
							<li><img src="<?php echo wp_get_attachment_url( $id ); ?>"></li>
						<?php endforeach; ?> 
						</ul>
						<a href="#" class="prev1"><i class="fa fa-angle-left"></i></a>
						<a href="#" class="next1"><i class="fa fa-angle-right"></i></a>
					</div>

					<div class="col grid_6_of_12">
						<h1><?php the_title(); ?></h1>
						<div class="proc-content">
							<?php the_content(); ?>
						</div>
						<div id="soc-share">
							<h5>Share with friends:</h5>
							<div class="share42init" data-url="<?php the_permalink() ?>" data-title="<?php the_title() ?>"></div>
							<script type="text/javascript" src="<?php echo esc_url( home_url( '/' ) ); ?>/share42/share42.js"></script>
						</div>
					</div>
				</div>
					<?php quark_content_nav( 'nav-below' ); ?>
				
				<?php endwhile; // end of the loop. ?>
			</div>
			<?php //get_sidebar(); ?>

	</div> <!-- /#primary.site-content.row -->

<?php get_footer(); ?>
