<?php
get_header();

$thumbnail_size = 'medium';

$show_posts = false;
$tax = 'projects-cat';  // slug of taxonomy to list
$terms = get_terms($tax, array( 'posts_per_page' => -1, 'orderby'=> 'title', 'order' => 'ASC' ) );
$current_catid = $wp_query->get_queried_object_id();
$children = get_term_children($current_catid, 'projects-cat');

if( empty( $children ) ) {
	$show_posts = true;
}

?>
<div class="container">
	<div class="row-bs">
		<div class="col-md-12">
			<?php if ( function_exists('yoast_breadcrumb') ) {yoast_breadcrumb('<p id="breadcrumbs">','</p>');} ?>
		</div>
	</div>
	<div class="row-bs">
		<div class="col-md-12">
			<h1 class="cat-portfolio title-header"><?php printf( single_cat_title( '', false ) ); ?></h1>
		</div>
	</div>
	<div class="row-bs brands-wrapper">
	<?php
		global $query_string;
		query_posts($query_string . '&orderby=title&order=asc');
					
		foreach ( $children as $child ) {
			$term = get_term_by( 'id', $child, $tax );
			echo '<div class="col-md-3 col-sx-6"><div class="brand-item"><h5><a href="' . get_term_link( $child, $tax ) . '">' . '<img src="'. z_taxonomy_image_url().'" alt="">' . $term->name . '</a></h5></div></div>';
		}
	?>
	</div>	
</div>
<?php get_footer(); ?>