<?php
get_header();

$thumbnail_size = 'medium';

$show_posts = false;
$tax = 'projects-cat';  // slug of taxonomy to list
$terms = get_terms($tax, array( 'posts_per_page' => -1, 'orderby'=> 'title', 'order' => 'ASC' ) );
$current_catid = $wp_query->get_queried_object_id();

$children = get_term_children($current_catid, 'projects-cat');

if( empty( $children ) ) {
	$show_posts = true;
}



?>
<div id="primary" class="site-content" role="main">
	<div class="row-bs">
		<div class="col-md-12">
			<?php if ( function_exists('yoast_breadcrumb') ) {yoast_breadcrumb('<p id="breadcrumbs">','</p>');} ?>
		</div>
	</div>
	<div class="row-bs">
		<div class="col-md-12">
			<h1 class="cat-portfolio title-header"><?php printf( single_cat_title( '', false ) ); ?></h1>
		</div>
		<div class="col-md-12">
		<?php
		if( $show_posts ) {
			the_posts_pagination( array(
				'mid_size' => 3,
				'prev_text' => '<',
				'next_text' => '>',
				'screen_reader_text' => 'Page'
			) );
		}
		?>
		</div>
	</div>
<?php




global $query_string;

query_posts($query_string . '&orderby=title&order=asc');
?>
    <?php if( have_posts() && $show_posts ):?>
        <div class="portfolio-wrapper row-bs">
        <?php
            $i=1;
            $terms_name = '';
            while( have_posts() ) : the_post();
                // Item terms
                //$terms = get_the_terms( get_the_ID(), 'portfolio_category' );
                // Getting the items featured images
                $thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), $thumbnail_size); 
				?>
            <div id="folio-<?php the_ID();?>" class="col-md-3">
				<div class="proj-item">
					<div class="feat-img">
						
							<?/*<img src="<?php echo esc_attr($thumb[0]);?>" alt="<?php the_title_attribute();?>" > */ ?>
							<div class="carousel">
								<ul id="proj-imgs" class="proj-imgs">
								<?php
								$galleryArray = get_post_gallery_ids($post->ID); 
								foreach ($galleryArray as $id) : ?>
									<li><img src="<?php echo wp_get_attachment_url( $id ); ?>"></li>
								<?php endforeach; ?> 
								</ul>
								<a href="#" class="prev1"><i class="fa fa-angle-left"></i></a>
								<a href="#" class="next1"><i class="fa fa-angle-right"></i></a>
							</div>
						
					</div>
					<div class="f_hover">
						<h5><a href="<?php the_permalink();?>"><?php the_title();?></a></h5>
					</div>
				</div>
			</div><!-- portfolio item -->
			
            <?php
            $i++;
            endwhile;
            ?>
        </div>
		<?php
			the_posts_pagination( array(
				'mid_size' => 3,
				'prev_text' => '<',
				'next_text' => '>',
				'screen_reader_text' => 'Page'
			) );
		?>

        <?php
		/*
            else:
                echo 'Nothing Found'; */
            endif;
        ?>
</div>
<?php get_footer(); ?>